(function() {
  //farmerswife SL - 19/03/2014
  define(['jquery', 'Backbone', 'Backbone.LocalStorage', 'moment', 'models/notification/NotificationModel', 'models/request/RequestModel'], function($, Backbone, LocalStorage, Moment, NotificationModel, RequestModel) {
    var NotificationCollection;
    return NotificationCollection = (function() {
      class NotificationCollection extends Backbone.Collection {
        initialize() {
          return this.reqMdl = new RequestModel();
        }

        get_notifications(usr) {
          var jsonReq, response, that, xmlReq;
          jsonReq = this.reqMdl.get('JGetNotifications');
          this.reqMdl.__setNodeValue(jsonReq, 'sessionID', usr.get('sessionID'));
          xmlReq = this.reqMdl.__getXML(jsonReq);
          that = this;
          response = this.reqMdl.__send_server_xmlrequest(xmlReq);
          response.done(function(data, textStatus, jqXHR) {
            var jsonObj, ref;
            jsonObj = data;
            if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
              if (((ref = jsonObj.Result) != null ? ref.cacheIsUpToDate : void 0) === 1) {
                return that.trigger('collectionNotificationFilled');
              } else {
                that.reset(jsonObj.Result.Notification);
                return that.trigger('collectionNotificationFilled');
              }
            } else {
              if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
                window.localStorage.clear();
                return window.location.href = 'index.html?expired=1';
              }
            }
          }).fail(function(data, textStatus, jqXHR) {
            //console.log "ERROR #{textStatus} "+data
            return false;
          });
          return this;
        }

      };

      NotificationCollection.prototype.model = NotificationModel;

      return NotificationCollection;

    }).call(this);
  });

}).call(this);
